/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6544;
import net.minecraft.class_7243;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeData;
import org.betterx.bclib.api.v2.levelgen.biomes.VanillaBiomeSettings;
import org.betterx.bclib.util.WeightedList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BCLBiome
extends BCLBiomeSettings
implements BiomeData {
    public static final Codec<BCLBiome> CODEC = RecordCodecBuilder.create(instance -> BCLBiome.codecWithSettings(instance).apply((Applicative)instance, BCLBiome::new));
    public static final class_7243<BCLBiome> KEY_CODEC = class_7243.method_42115(CODEC);
    protected final WeightedList<BCLBiome> subbiomes = new WeightedList();
    private final Map<String, Object> customData = Maps.newHashMap();
    private final class_2960 biomeID;
    private final class_5321<class_1959> biomeKey;
    final class_1959 biomeToRegister;
    protected final List<class_6544.class_4762> parameterPoints = Lists.newArrayList();
    private BCLBiome biomeParent;
    private BiomeAPI.BiomeType intendedType = BiomeAPI.BiomeType.NONE;
    private final boolean didLoadConfig = false;

    @Override
    public class_7243<? extends BCLBiome> codec() {
        return KEY_CODEC;
    }

    public static <T extends BCLBiome, P12> Products.P12<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<WeightedList<class_2960>>, Optional<String>, P12> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P12> p12) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t9, a.t10, p12);
    }

    public static <T extends BCLBiome, P12, P13> Products.P13<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<WeightedList<class_2960>>, Optional<String>, P12, P13> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t9, a.t10, p12, p13);
    }

    public static <T extends BCLBiome, P12, P13, P14, P15> Products.P15<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<WeightedList<class_2960>>, Optional<String>, P12, P13, P14, P15> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14, RecordCodecBuilder<T, P15> p15) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t9, a.t10, p12, p13, p14, p15);
    }

    public static <T extends BCLBiome, P12, P13, P14> Products.P14<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<WeightedList<class_2960>>, Optional<String>, P12, P13, P14> codecWithSettings(RecordCodecBuilder.Instance<T> instance, RecordCodecBuilder<T, P12> p12, RecordCodecBuilder<T, P13> p13, RecordCodecBuilder<T, P14> p14) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t9, a.t10, p12, p13, p14);
    }

    public static <T extends BCLBiome> Products.P11<RecordCodecBuilder.Mu<T>, Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<WeightedList<class_2960>>, Optional<String>> codecWithSettings(RecordCodecBuilder.Instance<T> instance) {
        CodecAttributes a = new CodecAttributes();
        return instance.group(a.t0, a.t1, a.t2, a.t3, a.t4, a.t5, a.t6, a.t7, a.t8, a.t9, a.t10);
    }

    protected BCLBiome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<class_2960> edge, class_2960 biomeID, Optional<List<class_6544.class_4762>> parameterPoints, Optional<class_2960> biomeParent, Optional<WeightedList<class_2960>> subbiomes, Optional<String> intendedType) {
        super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge.map(BiomeAPI::getBiome).orElse(null));
        this.biomeToRegister = null;
        this.biomeID = biomeID;
        this.biomeKey = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)biomeID);
        if (subbiomes.isEmpty() || subbiomes.get().size() == 0) {
            this.subbiomes.add(this, 1.0f);
        } else {
            this.subbiomes.addAll(subbiomes.get().map(BiomeAPI::getBiome));
        }
        this.biomeParent = biomeParent.map(BiomeAPI::getBiome).orElse(null);
        if (parameterPoints.isPresent()) {
            this.parameterPoints.addAll((Collection<class_6544.class_4762>)parameterPoints.get());
        }
        this.setIntendedType(intendedType.map(t -> BiomeAPI.BiomeType.create(t)).orElse(BiomeAPI.BiomeType.NONE));
    }

    protected BCLBiome(class_5321<class_1959> biomeKey) {
        this(biomeKey.method_29177());
    }

    protected BCLBiome(class_2960 biomeID) {
        this((class_5321<class_1959>)class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)biomeID), null);
    }

    @ApiStatus.Internal
    BCLBiome(class_1959 biomeToRegister, VanillaBiomeSettings settings) {
        this(BiomeAPI.getBiomeID(biomeToRegister), biomeToRegister, (BCLBiomeSettings)settings);
    }

    @ApiStatus.Internal
    public BCLBiome(class_2960 biomeID, class_1959 biomeToRegister, BiomeAPI.BiomeType type) {
        this(biomeID, biomeToRegister, (BCLBiomeSettings)null);
        this.setIntendedType(type);
    }

    protected BCLBiome(class_2960 biomeID, class_1959 biomeToRegister, BCLBiomeSettings defaults) {
        this((class_5321<class_1959>)class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)biomeID), biomeToRegister, defaults);
    }

    protected BCLBiome(class_5321<class_1959> biomeKey, BCLBiomeSettings defaults) {
        this(biomeKey, null, defaults);
    }

    protected BCLBiome(class_5321<class_1959> biomeKey, class_1959 biomeToRegister, BCLBiomeSettings defaults) {
        this.biomeToRegister = biomeToRegister;
        this.subbiomes.add(this, 1.0f);
        this.biomeID = biomeKey.method_29177();
        this.biomeKey = biomeKey;
        if (defaults != null) {
            defaults.applyWithDefaults(this);
        }
    }

    protected BCLBiome setIntendedType(BiomeAPI.BiomeType type) {
        return this._setIntendedType(type);
    }

    BCLBiome _setIntendedType(BiomeAPI.BiomeType type) {
        this.intendedType = type;
        return this;
    }

    public BiomeAPI.BiomeType getIntendedType() {
        return this.intendedType;
    }

    @Override
    @Nullable
    public BCLBiome getEdge() {
        return this.edge;
    }

    BCLBiome setEdge(BCLBiome edge) {
        this.edge = edge;
        edge.biomeParent = this;
        return this;
    }

    public BCLBiome addEdge(BCLBiome edge) {
        if (this.edge != null) {
            this.edge.addSubBiome(edge);
        } else {
            this.setEdge(edge);
        }
        return this;
    }

    public BCLBiome addSubBiome(BCLBiome biome) {
        biome.biomeParent = this;
        this.subbiomes.add(biome, biome.getGenChance());
        return this;
    }

    public boolean containsSubBiome(BCLBiome biome) {
        return this.subbiomes.contains(biome);
    }

    public BCLBiome getSubBiome(class_2919 random) {
        return this.subbiomes.get((class_5819)random);
    }

    public void forEachSubBiome(BiConsumer<BCLBiome, Float> consumer) {
        for (int i = 0; i < this.subbiomes.size(); ++i) {
            consumer.accept(this.subbiomes.get(i), Float.valueOf(this.subbiomes.getWeight(i)));
        }
    }

    @Nullable
    public BCLBiome getParentBiome() {
        return this.biomeParent;
    }

    public boolean isSame(BCLBiome biome) {
        return biome == this || biome.biomeParent != null && biome.biomeParent == this;
    }

    public class_2960 getID() {
        return this.biomeID;
    }

    public class_5321<class_1959> getBiomeKey() {
        return this.biomeKey;
    }

    public class_5321<BCLBiome> getBCLBiomeKey() {
        return class_5321.method_29179(BCLBiomeRegistry.BCL_BIOMES_REGISTRY, (class_2960)this.biomeID);
    }

    void afterRegistration() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        BCLBiome biome = (BCLBiome)obj;
        return biome != null && this.biomeID.equals((Object)biome.biomeID);
    }

    public int hashCode() {
        return this.biomeID.hashCode();
    }

    public String toString() {
        return this.biomeID.toString();
    }

    void addClimateParameters(List<class_6544.class_4762> params) {
        this.parameterPoints.addAll(params);
    }

    public void forEachClimateParameter(Consumer<class_6544.class_4762> consumer) {
        this.parameterPoints.forEach(consumer);
    }

    public String configGroup() {
        return this.biomeID.method_12836() + "." + this.biomeID.method_12832();
    }

    public boolean isEdgeBiome() {
        if (this.getParentBiome() == null) {
            return false;
        }
        return this.getParentBiome().edge == this;
    }

    boolean allowFabricRegistration() {
        return !this.isEdgeBiome();
    }

    private static class CodecAttributes<T extends BCLBiome> {
        public RecordCodecBuilder<T, Float> t0 = Codec.FLOAT.fieldOf("terrainHeight").orElse((Object)Float.valueOf(0.1f)).forGetter(o1 -> Float.valueOf(o1.terrainHeight));
        public RecordCodecBuilder<T, Float> t1 = Codec.FLOAT.fieldOf("fogDensity").orElse((Object)Float.valueOf(1.0f)).forGetter(o1 -> Float.valueOf(o1.fogDensity));
        public RecordCodecBuilder<T, Float> t2 = Codec.FLOAT.fieldOf("genChance").orElse((Object)Float.valueOf(1.0f)).forGetter(o1 -> Float.valueOf(o1.genChance));
        public RecordCodecBuilder<T, Integer> t3 = Codec.INT.fieldOf("edgeSize").orElse((Object)0).forGetter(o1 -> o1.edgeSize);
        public RecordCodecBuilder<T, Boolean> t4 = Codec.BOOL.fieldOf("vertical").orElse((Object)false).forGetter(o1 -> o1.vertical);
        public RecordCodecBuilder<T, Optional<class_2960>> t5 = class_2960.field_25139.optionalFieldOf("edge").orElse(Optional.empty()).forGetter(o1 -> o1.edge == null ? Optional.empty() : Optional.of(o1.edge.biomeID));
        public RecordCodecBuilder<T, class_2960> t6 = class_2960.field_25139.fieldOf("biome").forGetter(o -> o.biomeID);
        public RecordCodecBuilder<T, Optional<List<class_6544.class_4762>>> t7 = class_6544.class_4762.field_24679.listOf().optionalFieldOf("parameter_points").orElse(Optional.of(List.of())).forGetter(o -> o.parameterPoints == null || o.parameterPoints.isEmpty() ? Optional.empty() : Optional.of(o.parameterPoints));
        public RecordCodecBuilder<T, Optional<class_2960>> t8 = class_2960.field_25139.optionalFieldOf("parent").orElse(Optional.empty()).forGetter(o1 -> o1.biomeParent == null ? Optional.empty() : Optional.of(o1.biomeParent.biomeID));
        public RecordCodecBuilder<T, Optional<WeightedList<class_2960>>> t9 = WeightedList.listCodec(class_2960.field_25139, "biomes", "biome").optionalFieldOf("sub_biomes").forGetter(o -> {
            if (o.subbiomes == null || o.subbiomes.isEmpty() || o.subbiomes.size() == 1 && o.subbiomes.contains((BCLBiome)o)) {
                return Optional.empty();
            }
            return Optional.of(o.subbiomes.map(b -> b.biomeID));
        });
        public RecordCodecBuilder<T, Optional<String>> t10 = Codec.STRING.optionalFieldOf("intended_for").orElse(Optional.of(BiomeAPI.BiomeType.NONE.getName())).forGetter(o -> o.intendedType == null ? Optional.empty() : Optional.of(o.intendedType.getName()));

        private CodecAttributes() {
        }
    }
}

